#include "ScenaRysowana.h"


void CScenaRysowana::Rysuj(void)
{
	using namespace std;
	if(this->modele.empty())
		return;

	vector<CModelWsk>::const_iterator model = modele.begin();

	glBegin(GL_TRIANGLES);
	while(model != modele.end())
	{
		const vector<STrojkat>& trojkaty = (*model)->Trojkaty();
		vector<STrojkat>::const_iterator trojkat = trojkaty.begin();

		glBegin(GL_TRIANGLES);
		switch((*model)->TypTrojkatow())
		{
		case TYPTROJKATA_W: //same Wierzchoki
			while(trojkat != trojkaty.end()){
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w1]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w2]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w3]));
				trojkat++;
			}
			break;
		case TYPTROJKATA_WT: //Wierzchoki i wsp. Tekstur
			while(trojkat != trojkaty.end()){
				glTexCoord2fv(reinterpret_cast<const GLfloat *>(&wspolrzedneTekstur[(*trojkat).t1]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w1]));
				glTexCoord2fv(reinterpret_cast<const GLfloat *>(&wspolrzedneTekstur[(*trojkat).t2]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w2]));
				glTexCoord2fv(reinterpret_cast<const GLfloat *>(&wspolrzedneTekstur[(*trojkat).t3]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w3]));
				trojkat++;
			}
			break;
		case TYPTROJKATA_WN: //Wierzchoki i Normalne
			while(trojkat != trojkaty.end()){
				glNormal3fv(reinterpret_cast<const GLfloat *>(&normalne[(*trojkat).n1]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w1]));
				glNormal3fv(reinterpret_cast<const GLfloat *>(&normalne[(*trojkat).n2]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w2]));
				glNormal3fv(reinterpret_cast<const GLfloat *>(&normalne[(*trojkat).n3]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w3]));
				trojkat++;
			}
			break;
		case TYPTROJKATA_WTN: //Wierzchoki, wspolrzedne Tekstur i Normalne
			while(trojkat != trojkaty.end()){
				glTexCoord2fv(reinterpret_cast<const GLfloat *>(&wspolrzedneTekstur[(*trojkat).t1]));
				glNormal3fv(reinterpret_cast<const GLfloat *>(&normalne[(*trojkat).n1]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w1]));
				glTexCoord2fv(reinterpret_cast<const GLfloat *>(&wspolrzedneTekstur[(*trojkat).t2]));
				glNormal3fv(reinterpret_cast<const GLfloat *>(&normalne[(*trojkat).n2]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w2]));
				glTexCoord2fv(reinterpret_cast<const GLfloat *>(&wspolrzedneTekstur[(*trojkat).t3]));
				glNormal3fv(reinterpret_cast<const GLfloat *>(&normalne[(*trojkat).n3]));
				glVertex4fv(reinterpret_cast<const GLfloat *>(&wierzcholki[(*trojkat).w3]));
				trojkat++;
			}
			break;
		default: //TYPTROJKATA_NIEPOPRAWNY - obiekt zdefiniowany ale bez adnych powierzchni
			continue;
		}
		model++;
	}
	glEnd();
}